/* Written by Yu-Fang Chen, Richard Mayr, and Chih-Duo Hong               */
/* Copyright (c) 2010                  	                                  */
/*                                                                        */
/* This program is free software; you can redistribute it and/or modify   */
/* it under the terms of the GNU General Public License as published by   */
/* the Free Software Foundation; either version 2 of the License, or      */
/* (at your option) any later version.                                    */
/*                                                                        */
/* This program is distributed in the hope that it will be useful,        */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/* GNU General Public License for more details.                           */
/*                                                                        */
/* You should have received a copy of the GNU General Public License      */
/* along with this program; if not, write to the Free Software            */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*/

package mainfiles;

import java.lang.management.*;

import java.util.Random;
import java.util.TreeMap;

import automata.FAState;
import automata.FiniteAutomaton;

import algorithms.InclusionAnti;
import algorithms.InclusionOpt;
import algorithms.InclusionOptBVLayered;
import algorithms.Options;
import java.util.Iterator;

/**
 * 
 * @author Yu-Fang Chen
 * 
 */
public class CheckingInclusion_SimulationSubsumption {
	static long timeout=0;
	static boolean timeout_set=false;
	/** Get CPU time in nanoseconds. */
	static public long getCpuTime( long id) {
	    ThreadMXBean bean = ManagementFactory.getThreadMXBean( );
	    if ( ! bean.isThreadCpuTimeSupported( ) )
	        return 0L;
	    else
	    	return bean.getThreadCpuTime(id);
	}
	

	// Transform finite automata into BA s.t. language inclusion is preserved.
	    private static FiniteAutomaton toBA(FiniteAutomaton aut){
		if(aut.alphabet.contains("specialaction359")){
			System.out.println("Error: Alphabet name clash. Exiting.");
			System.exit(0);
		    }
		FAState acc = aut.createState();
		Iterator<FAState> it=aut.F.iterator();
		while(it.hasNext()){
		    FAState state=it.next();
		    aut.addTransition(state, acc, "specialaction359");
		}
		aut.addTransition(acc, acc, "specialaction359");
		aut.F.clear();
		aut.F.add(acc);
		return aut;
	    }


	public static void main(String[] args) {
		boolean antichain=false;
		System.out.println("RABIT v1.1.0 (Ramsey-based Buchi automata inclusion testing)");
		for(int i=0;i<args.length;i++){
			if(args[i].compareTo("-h")==0){
				System.out.println("Usage: java -jar RABIT.jar aut1.BA aut2.BA [-h -q -qr -c -rd -DFS -SFS -fplus -b -d -v -eb -cpt -sp -de]");
				System.out.println("-h: Show this page");
				System.out.println("-q: Do quotienting w.r.t. forward simulation");
				System.out.println("-qr: Do fw/bw quotienting and removal of useless transitions repeatedly until a fixed point is reached. Overrides -q");
				System.out.println("-c: Use forward simulation between aut1 and aut2");
				System.out.println("-rd: Remove dead states");
				System.out.println("-DFS: Use DFS searching strategy (default: BFS strategy)");
				System.out.println("-SFS: Use smallest-first searching strategy (default: BFS strategy)");
				System.out.println("-fplus: Use one-step-further forward simulation");
				System.out.println("-b: Use backward simulation");
				System.out.println("-d: Debug mode");
				System.out.println("-v: Verbose mode");
				System.out.println("-eb: Earlier detection of counterexamples (with minimal overhead)");
				System.out.println("-cpt: Do a cheap pretest before subsumption checking.");
				System.out.println("-sp: Apply more extensive automata minimization and preprocessing. Only effective when used together with options -b -qr -rd.");
				System.out.println("-de: Use delayed simulation. Overrides -q.");
				System.out.println("For best performance we recommend options -b -rd -fplus -SFS -qr -c -eb -cpt -sp -de");
				System.out.println("Option -finite switches to a different semantics: Interpret input as finite automata (not Buchi automata).");
				System.exit(0);
			}
		}

		if(args.length<2){
	 			System.out.println("Usage: java -jar RABIT.jar aut1.BA aut2.BA [-h -q -qr -c -rd -DFS -SFS -fplus -b -d -v -eb -cpt -sp -de]");
				System.out.println("-h: Show this page");
				System.out.println("-q: Do quotienting w.r.t. forward simulation");
				System.out.println("-qr: Do fw/bw quotienting and removal of useless transitions repeatedly until a fixed point is reached. Overrides -q");
				System.out.println("-c: Use forward simulation between aut1 and aut2");
				System.out.println("-rd: Remove dead states");
				System.out.println("-DFS: Use DFS searching strategy (default: BFS strategy)");
				System.out.println("-SFS: Use smallest-first searching strategy (default: BFS strategy)");
				System.out.println("-fplus: Use one-step-further forward simulation");
				System.out.println("-b: Use backward simulation");
				System.out.println("-d: Debug mode");
				System.out.println("-v: Verbose mode");
				System.out.println("-eb: Earlier detection of counterexamples (with minimal overhead)");
				System.out.println("-cpt: Do a cheap pretest before subsumption checking.");
				System.out.println("-sp: Apply more extensive automata minimization and preprocessing. Only effective when used together with options -b -qr -rd.");
				System.out.println("-de: Use delayed simulation. Overrides -q.");
				System.out.println("For best performance we recommend options -b -rd -fplus -SFS -qr -c -eb -cpt -sp -de");
				System.out.println("Option -finite switches to a different semantics: Interpret input as finite automata (not Buchi automata).");
			return;
		}
		long ttime1;
		FiniteAutomaton aut1 = new FiniteAutomaton(args[0]);
		aut1.name="A";
		FiniteAutomaton aut2 = new FiniteAutomaton(args[1]);
		aut2.name="B";

		Options.quotient=false;
		Options.C1=false;
		Options.CPT=false;
		Options.EB=false;
		Options.backward=false;
		Options.opt2=true;
		Options.debug=false;
		Options.fplus=false;
		Options.rd=false;
		Options.DFS=false;
		Options.qr=false;
		Options.verbose=false;
		Options.superpruning=false;
		Options.delayed=false;
		Options.finite=false;
		
		for(int i=2;i<args.length;i++){
			if(args[i].compareTo("-qr")==0){
				Options.qr=true;
			}
			if(args[i].compareTo("-q")==0){
				Options.quotient=true;
			}
			if(args[i].compareTo("-rd")==0){
				Options.rd=true;
			}
			if(args[i].compareTo("-c")==0){
				Options.C1=true;
			}
			if(args[i].compareTo("-eb")==0){
				Options.EB=true;
			}

			if(args[i].compareTo("-DFS")==0){
				Options.DFS=true;
			}
			if(args[i].compareTo("-SFS")==0){
				Options.SFS=true;
			}
			if(args[i].compareTo("-cpt")==0){
				Options.CPT=true;
			}
			if(args[i].compareTo("-b")==0){
				Options.backward=true;
			}
			if(args[i].compareTo("-fplus")==0){
				Options.fplus=true;
			}
			if(args[i].compareTo("-d")==0){
				Options.debug=true;
			}
			if(args[i].compareTo("-v")==0){
				Options.verbose=true;
			}
			if(args[i].compareTo("-sp")==0){
				Options.superpruning=true;
			}
			if(args[i].compareTo("-de")==0){
				Options.delayed=true;
			}
			if(args[i].compareTo("-finite")==0){
				Options.finite=true;
			}	
			if(args[i].compareTo("-antichain")==0){
				antichain=true;
			}
		}

		if(Options.finite){
		    aut1=toBA(aut1);
		    aut2=toBA(aut2);
		    System.out.println("Interpreting the automata as finite automata (not Buchi-automata!).");
		}

		System.out.println("Aut A: # of Trans. "+aut1.trans+", # of States "+aut1.states.size()+".");
		System.out.println("Aut B: # of Trans. "+aut2.trans+", # of States "+aut2.states.size()+".");
		if(!antichain){
			InclusionOptBVLayered inclusion=new InclusionOptBVLayered(aut1,aut2);
			inclusion.run();
			ttime1=inclusion.getRunTime();
			if(inclusion.isIncluded()){
				System.out.println("Included");
			}else{
				System.out.println("Not Included");
			}
			System.out.println("Metagraphs added to the Next set "+inclusion.mggen);
			System.out.println("Time for the Simulation Subsumption algorithm(ms): "+ttime1/1000000+".");
		}else{
			InclusionAnti inclusion=new InclusionAnti(aut1,aut2);
			inclusion.run();
			ttime1=inclusion.getRunTime();
			if(inclusion.isIncluded()){
				System.out.println("Included");
			}else{
				System.out.println("Not Included");
			}
			System.out.println("Time for the Simulation Subsumption algorithm(ms): "+ttime1/1000000+".");
		}
		
	}
}
